#include "General.h"
#include "CustomRadioCommands.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

int LastPress[128];
int PressWaitTime = 0;
bool PrefixRadio = false;
bool LimitRadioSpam = false;
bool EnableStockRadioCommands = false;
bool EnableTauntRadioCommands = false;

SimpleDynVecClass<RadioCommand *> Ctrl_1_GDI, Ctrl_2_GDI, Ctrl_3_GDI, Ctrl_4_GDI, Ctrl_5_GDI;
SimpleDynVecClass<RadioCommand *> Ctrl_6_GDI, Ctrl_7_GDI, Ctrl_8_GDI, Ctrl_9_GDI, Ctrl_0_GDI;
SimpleDynVecClass<RadioCommand *> Ctrl_1_Nod, Ctrl_2_Nod, Ctrl_3_Nod, Ctrl_4_Nod, Ctrl_5_Nod;
SimpleDynVecClass<RadioCommand *> Ctrl_6_Nod, Ctrl_7_Nod, Ctrl_8_Nod, Ctrl_9_Nod, Ctrl_0_Nod;

SimpleDynVecClass<RadioCommand *> Alt_1_GDI, Alt_2_GDI, Alt_3_GDI, Alt_4_GDI, Alt_5_GDI;
SimpleDynVecClass<RadioCommand *> Alt_6_GDI, Alt_7_GDI, Alt_8_GDI, Alt_9_GDI, Alt_0_GDI;
SimpleDynVecClass<RadioCommand *> Alt_1_Nod, Alt_2_Nod, Alt_3_Nod, Alt_4_Nod, Alt_5_Nod;
SimpleDynVecClass<RadioCommand *> Alt_6_Nod, Alt_7_Nod, Alt_8_Nod, Alt_9_Nod, Alt_0_Nod;

SimpleDynVecClass<RadioCommand *> CtrlAlt_1_GDI, CtrlAlt_2_GDI, CtrlAlt_3_GDI, CtrlAlt_4_GDI, CtrlAlt_5_GDI;
SimpleDynVecClass<RadioCommand *> CtrlAlt_6_GDI, CtrlAlt_7_GDI, CtrlAlt_8_GDI, CtrlAlt_9_GDI, CtrlAlt_0_GDI;
SimpleDynVecClass<RadioCommand *> CtrlAlt_1_Nod, CtrlAlt_2_Nod, CtrlAlt_3_Nod, CtrlAlt_4_Nod, CtrlAlt_5_Nod;
SimpleDynVecClass<RadioCommand *> CtrlAlt_6_Nod, CtrlAlt_7_Nod, CtrlAlt_8_Nod, CtrlAlt_9_Nod, CtrlAlt_0_Nod;

SimpleDynVecClass<RadioCommand *> Taunt1_GDI, Taunt2_GDI, Taunt3_GDI, Taunt4_GDI, Taunt5_GDI;
SimpleDynVecClass<RadioCommand *> Taunt6_GDI, Taunt7_GDI, Taunt8_GDI, Taunt9_GDI;
 
SimpleDynVecClass<RadioCommand *> Taunt1_Nod, Taunt2_Nod, Taunt3_Nod, Taunt4_Nod, Taunt5_Nod;
SimpleDynVecClass<RadioCommand *> Taunt6_Nod, Taunt7_Nod, Taunt8_Nod, Taunt9_Nod;

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);
	Console_Input(buffer);
}

void Load_Radio_Command(char *Section, SimpleDynVecClass<RadioCommand *>& Vec)
{
	INIClass *ini = Get_INI("../custom_radio_commands.ini");
	if(!ini)
	{
		Console_Output("Plugin Sounds Error: custom_radio_commands.ini not found in the main FDS folder.\n");
	}
	else
	{
		char entry[128];
		char buffer[256], buffer2[256], buffer3[256];
		for(int i = 1; i < 256; i++)
		{
			sprintf(entry, "%.2d_Text", i);
			ini->Get_String(Section, entry, "", buffer, 256);
			sprintf(entry, "%.2d_Sound", i);
			ini->Get_String(Section, entry, "", buffer2, 256);
			sprintf(entry, "%.2d_Icon", i);
			ini->Get_String(Section, entry, "", buffer3, 256);
			
			if(*entry != 0)
			{
				RadioCommand *r = new RadioCommand;
				if(sscanf(buffer, "%s", r->Text) < 1)
				{
					break;					
				}
				if(sscanf(buffer2, "%s", r->Sound) < 1)
				{
					break;
				}
				if(sscanf(buffer3, "%s", r->Icon) < 1)
				{
					break;
				}
				strcpy(r->Text, buffer);
				strcpy(r->Sound, buffer2);
				strcpy(r->Icon, buffer3);
				Vec.Add(r);					
				continue;
			}
			break;
		}
    Release_INI(ini);
	}
} 


void Plugin_Load() 
{
	INIClass *ini = Get_INI("../custom_radio_commands.ini");
	EnableStockRadioCommands = ini->Get_Bool("General", "EnableStockRadioCommands", false);
	EnableTauntRadioCommands = ini->Get_Bool("General", "EnableTauntRadioCommands", false);
	PrefixRadio = ini->Get_Bool("General", "PrefixRadio", false);
	PressWaitTime = ini->Get_Int("General", "PressWaitTime", false);
	LimitRadioSpam = ini->Get_Bool("General", "LimitRadioSpam", false);

	Release_INI(ini);

	if (EnableStockRadioCommands)
	{
		Load_Radio_Commands();
	}

	if (EnableTauntRadioCommands)
	{
		new ScriptRegistrant<Iran_Radio_Taunt_Key>("MDB_SSGM_Taunt_Key", "Key:string,Anim:string");
		//ScriptRegistrant<Iran_Radio_Taunt_Key> MDB_SSGM_Taunt_Key_Registrant("MDB_SSGM_Taunt_Key","Key:string,Anim:string");
		Load_Taunt_Radio_Commands();
	}

	// DEBUG CRAP
//	Console_Output("Count = %d\n", Ctrl_2_GDI.Count());
//	Console_Output("%s %s %s\n", Ctrl_2_GDI[0]->Text, Ctrl_2_GDI[0]->Sound, Ctrl_2_GDI[0]->Icon);
} 

void Play_Random_Radio_Command(SimpleDynVecClass<RadioCommand *>& Vec, int Team, int ID)
{
	char tmp[256];
	LARGE_INTEGER cicles;

	QueryPerformanceCounter(&cicles);
	srand((unsigned int)cicles.QuadPart);
	int i = rand() % Vec.Count();
	sprintf(tmp, "sndt %d %s", Team, Vec[i]->Sound);
	Console_Input(tmp);
	sprintf(tmp, "%s", PrefixRadio ? "[Radio] " : ""); 
	sprintf(tmp, "%s%s: %s", tmp, Get_Player_Name_By_ID(ID), Vec[i]->Text);
	unsigned int Red = 0,Blue = 0,Green = 0;
	Get_Team_Color(Team,&Red,&Green,&Blue);
	if (PrefixRadio)
	{
		if (Team == 1)
			Send_Message_Team(1, Red, Green, Blue, tmp);
		else		  
			Send_Message_Team(0, Red, Green, Blue, tmp);
	}
	else
	{
		Console("TMSG %d %s", ID, Vec[i]->Text);
	}

	sprintf(tmp, "icon %d %s", ID, Vec[i]->Icon);
	Console_Input(tmp);
}

bool CustomRadioCommands::OnRadioCommand(int Team, int PlayerID, int a, int RadioID, uint8 b)
{
	if (LimitRadioSpam)
	{
		if (((int)The_Game()->Get_Game_Duration_S() - LastPress[PlayerID]) >= PressWaitTime ) 
		{
				LastPress[PlayerID] = The_Game()->Get_Game_Duration_S();
		}
		else
		{
			Send_Message_Player(Get_GameObj(PlayerID), 255, 255, 255, 
				"Your radio command has been blocked, please don't spam radio commands.");
			return false;
		}
	}

	if (!EnableStockRadioCommands) // return if custom stock radio commands aren't enabled
	{
		return true;
	}

	if (RadioID == 0) Play_Random_Radio_Command(Team ? Ctrl_1_GDI : Ctrl_1_Nod, Team, PlayerID);
	if (RadioID == 1) Play_Random_Radio_Command(Team ? Ctrl_2_GDI : Ctrl_2_Nod, Team, PlayerID);
	if (RadioID == 2) Play_Random_Radio_Command(Team ? Ctrl_3_GDI : Ctrl_3_Nod, Team, PlayerID);
	if (RadioID == 3) Play_Random_Radio_Command(Team ? Ctrl_4_GDI : Ctrl_4_Nod, Team, PlayerID);
	if (RadioID == 4) Play_Random_Radio_Command(Team ? Ctrl_5_GDI : Ctrl_5_Nod, Team, PlayerID);
	if (RadioID == 5) Play_Random_Radio_Command(Team ? Ctrl_6_GDI : Ctrl_6_Nod, Team, PlayerID);
	if (RadioID == 6) Play_Random_Radio_Command(Team ? Ctrl_7_GDI : Ctrl_7_Nod, Team, PlayerID);
	if (RadioID == 7) Play_Random_Radio_Command(Team ? Ctrl_8_GDI : Ctrl_8_Nod, Team, PlayerID);
	if (RadioID == 8) Play_Random_Radio_Command(Team ? Ctrl_9_GDI : Ctrl_9_Nod, Team, PlayerID);
	if (RadioID == 9) Play_Random_Radio_Command(Team ? Ctrl_0_GDI : Ctrl_0_Nod, Team, PlayerID);
	if (RadioID == 10) Play_Random_Radio_Command(Team ? Alt_1_GDI : Alt_1_Nod, Team, PlayerID);
	if (RadioID == 11) Play_Random_Radio_Command(Team ? Alt_2_GDI : Alt_2_Nod, Team, PlayerID);
	if (RadioID == 12) Play_Random_Radio_Command(Team ? Alt_3_GDI : Alt_3_Nod, Team, PlayerID);
	if (RadioID == 13) Play_Random_Radio_Command(Team ? Alt_4_GDI : Alt_4_Nod, Team, PlayerID);
	if (RadioID == 14) Play_Random_Radio_Command(Team ? Alt_5_GDI : Alt_5_Nod, Team, PlayerID);
	if (RadioID == 15) Play_Random_Radio_Command(Team ? Alt_6_GDI : Alt_6_Nod, Team, PlayerID);
	if (RadioID == 16) Play_Random_Radio_Command(Team ? Alt_7_GDI : Alt_7_Nod, Team, PlayerID);
	if (RadioID == 17) Play_Random_Radio_Command(Team ? Alt_8_GDI : Alt_8_Nod, Team, PlayerID);
	if (RadioID == 18) Play_Random_Radio_Command(Team ? Alt_9_GDI : Alt_9_Nod, Team, PlayerID);
	if (RadioID == 19) Play_Random_Radio_Command(Team ? Alt_0_GDI : Alt_0_Nod, Team, PlayerID);
	if (RadioID == 20) Play_Random_Radio_Command(Team ? CtrlAlt_1_GDI : CtrlAlt_1_Nod, Team, PlayerID);
	if (RadioID == 21) Play_Random_Radio_Command(Team ? CtrlAlt_2_GDI : CtrlAlt_2_Nod, Team, PlayerID);
	if (RadioID == 22) Play_Random_Radio_Command(Team ? CtrlAlt_3_GDI : CtrlAlt_3_Nod, Team, PlayerID);
	if (RadioID == 23) Play_Random_Radio_Command(Team ? CtrlAlt_4_GDI : CtrlAlt_4_Nod, Team, PlayerID);
	if (RadioID == 24) Play_Random_Radio_Command(Team ? CtrlAlt_5_GDI : CtrlAlt_5_Nod, Team, PlayerID);
	if (RadioID == 25) Play_Random_Radio_Command(Team ? CtrlAlt_6_GDI : CtrlAlt_6_Nod, Team, PlayerID);
	if (RadioID == 26) Play_Random_Radio_Command(Team ? CtrlAlt_7_GDI : CtrlAlt_7_Nod, Team, PlayerID);
	if (RadioID == 27) Play_Random_Radio_Command(Team ? CtrlAlt_8_GDI : CtrlAlt_8_Nod, Team, PlayerID);
	if (RadioID == 28) Play_Random_Radio_Command(Team ? CtrlAlt_9_GDI : CtrlAlt_9_Nod, Team, PlayerID);
	if (RadioID == 29) Play_Random_Radio_Command(Team ? CtrlAlt_0_GDI : CtrlAlt_0_Nod, Team, PlayerID);
	return false;
}

void KeyHookCall(void *Data2) {
	MDB_SSGM_KeyHook *Base = (MDB_SSGM_KeyHook *)Data2;
	Base->KeyHookFunc();
}

int MDB_SSGM_KeyHook::AddHook(const char *Key, GameObject *obj) {
	if (is_keyhook_set == 1337) {
		RemoveHook();
	}
	k = 0;
	k = new KeyHookStruct;
	k->data = this;
	k->hook = KeyHookCall;
	k->PlayerID = Get_Player_ID(obj);
	k->key = newstr(Key);
	hookid = AddKeyHook(k);
	return hookid;
}

void MDB_SSGM_KeyHook::RemoveHook() {
	if (hookid != 0 && RemoveKeyHook != 0) {
		RemoveKeyHook(hookid);
		hookid = 0;
		if (k != 0) {
			delete[] k->key;
			delete k;
			k = 0;
		}
	}
}

void MDB_SSGM_KeyHook::Detach(GameObject *obj) 
{
	if (is_keyhook_set == 1337) 
	{
		RemoveHook();
	}
}

void MDB_SSGM_KeyHook::Destroyed(GameObject *obj) 
{
	if (is_keyhook_set == 1337) 
	{
		RemoveHook();
	}
}

void Iran_Radio_Taunt_Key::Created(GameObject *obj) 
{
	if (is_keyhook_set != 1337) 
	{
		hookid = AddHook(Get_Parameter("Key"),obj);
		LastPress[Get_Player_ID(Owner())] = The_Game()->Get_Game_Duration_S()-5;
		is_keyhook_set = 1337;
	}
}

void Iran_Radio_Taunt_Key::KeyHookFunc() 
{
	const char* tmp = Get_Parameter("Key");
	Team = Get_Team(Get_Player_ID(Owner()));
	if (((int)The_Game()->Get_Game_Duration_S() - LastPress[Get_Player_ID(Owner())]) >= PressWaitTime ) 
	{
		if (strcmp(tmp, "Taunt1") ==0)
			Play_Random_Radio_Command(Team ? Taunt1_GDI : Taunt1_Nod, Team, Get_Player_ID(Owner()));
		else if (strcmp(tmp, "Taunt2") ==0)
			Play_Random_Radio_Command(Team ? Taunt2_GDI : Taunt2_Nod, Team, Get_Player_ID(Owner()));
		else if (strcmp(tmp, "Taunt3") ==0)
			Play_Random_Radio_Command(Team ? Taunt3_GDI : Taunt3_Nod, Team, Get_Player_ID(Owner()));
		else if (strcmp(tmp, "Taunt4") ==0)
			Play_Random_Radio_Command(Team ? Taunt4_GDI : Taunt4_Nod, Team, Get_Player_ID(Owner()));
		else if (strcmp(tmp, "Taunt5") ==0)
			Play_Random_Radio_Command(Team ? Taunt5_GDI : Taunt5_Nod, Team, Get_Player_ID(Owner()));
		else if (strcmp(tmp, "Taunt6") ==0)
			Play_Random_Radio_Command(Team ? Taunt6_GDI : Taunt6_Nod, Team, Get_Player_ID(Owner()));
		else if (strcmp(tmp, "Taunt7") ==0)
			Play_Random_Radio_Command(Team ? Taunt7_GDI : Taunt7_Nod, Team, Get_Player_ID(Owner()));
		else if (strcmp(tmp, "Taunt8") ==0)
			Play_Random_Radio_Command(Team ? Taunt8_GDI : Taunt8_Nod, Team, Get_Player_ID(Owner()));
		else if (strcmp(tmp, "Taunt9") ==0)
			Play_Random_Radio_Command(Team ? Taunt9_GDI : Taunt9_Nod, Team, Get_Player_ID(Owner()));

		LastPress[Get_Player_ID(Owner())] = The_Game()->Get_Game_Duration_S();
	}
	else
	{
		Send_Message_Player(Owner(), 255, 255, 255, 
			"Your radio command has been blocked, please don't spam radio commands.");
	}
}

void Load_Radio_Commands()
{
	Load_Radio_Command("Ctrl_1_GDI", Ctrl_1_GDI);
	Load_Radio_Command("Ctrl_1_Nod", Ctrl_1_Nod);
	Load_Radio_Command("Ctrl_2_GDI", Ctrl_2_GDI);
	Load_Radio_Command("Ctrl_2_Nod", Ctrl_2_Nod);
	Load_Radio_Command("Ctrl_3_GDI", Ctrl_3_GDI);
	Load_Radio_Command("Ctrl_3_Nod", Ctrl_3_Nod);
	Load_Radio_Command("Ctrl_4_GDI", Ctrl_4_GDI);
	Load_Radio_Command("Ctrl_4_Nod", Ctrl_4_Nod);
	Load_Radio_Command("Ctrl_5_GDI", Ctrl_5_GDI);
	Load_Radio_Command("Ctrl_5_Nod", Ctrl_5_Nod);
	Load_Radio_Command("Ctrl_6_GDI", Ctrl_6_GDI);
	Load_Radio_Command("Ctrl_6_Nod", Ctrl_6_Nod);
	Load_Radio_Command("Ctrl_7_GDI", Ctrl_7_GDI);
	Load_Radio_Command("Ctrl_7_Nod", Ctrl_7_Nod);
	Load_Radio_Command("Ctrl_8_GDI", Ctrl_8_GDI);
	Load_Radio_Command("Ctrl_8_Nod", Ctrl_8_Nod);
	Load_Radio_Command("Ctrl_9_GDI", Ctrl_9_GDI);
	Load_Radio_Command("Ctrl_9_Nod", Ctrl_9_Nod);
	Load_Radio_Command("Ctrl_0_GDI", Ctrl_0_GDI);
	Load_Radio_Command("Ctrl_0_Nod", Ctrl_0_Nod);

	Load_Radio_Command("Alt_1_GDI", Alt_1_GDI);
	Load_Radio_Command("Alt_1_Nod", Alt_1_Nod);
	Load_Radio_Command("Alt_2_GDI", Alt_2_GDI);
	Load_Radio_Command("Alt_2_Nod", Alt_2_Nod);
	Load_Radio_Command("Alt_3_GDI", Alt_3_GDI);
	Load_Radio_Command("Alt_3_Nod", Alt_3_Nod);
	Load_Radio_Command("Alt_4_GDI", Alt_4_GDI);
	Load_Radio_Command("Alt_4_Nod", Alt_4_Nod);
	Load_Radio_Command("Alt_5_GDI", Alt_5_GDI);
	Load_Radio_Command("Alt_5_Nod", Alt_5_Nod);
	Load_Radio_Command("Alt_6_GDI", Alt_6_GDI);
	Load_Radio_Command("Alt_6_Nod", Alt_6_Nod);
	Load_Radio_Command("Alt_7_GDI", Alt_7_GDI);
	Load_Radio_Command("Alt_7_Nod", Alt_7_Nod);
	Load_Radio_Command("Alt_8_GDI", Alt_8_GDI);
	Load_Radio_Command("Alt_8_Nod", Alt_8_Nod);
	Load_Radio_Command("Alt_9_GDI", Alt_9_GDI);
	Load_Radio_Command("Alt_9_Nod", Alt_9_Nod);
	Load_Radio_Command("Alt_0_GDI", Alt_0_GDI);
	Load_Radio_Command("Alt_0_Nod", Alt_0_Nod);

	Load_Radio_Command("CtrlAlt_1_GDI", CtrlAlt_1_GDI);
	Load_Radio_Command("CtrlAlt_1_Nod", CtrlAlt_1_Nod);
	Load_Radio_Command("CtrlAlt_2_GDI", CtrlAlt_2_GDI);
	Load_Radio_Command("CtrlAlt_2_Nod", CtrlAlt_2_Nod);
	Load_Radio_Command("CtrlAlt_3_GDI", CtrlAlt_3_GDI);
	Load_Radio_Command("CtrlAlt_3_Nod", CtrlAlt_3_Nod);
	Load_Radio_Command("CtrlAlt_4_GDI", CtrlAlt_4_GDI);
	Load_Radio_Command("CtrlAlt_4_Nod", CtrlAlt_4_Nod);
	Load_Radio_Command("CtrlAlt_5_GDI", CtrlAlt_5_GDI);
	Load_Radio_Command("CtrlAlt_5_Nod", CtrlAlt_5_Nod);
	Load_Radio_Command("CtrlAlt_6_GDI", CtrlAlt_6_GDI);
	Load_Radio_Command("CtrlAlt_6_Nod", CtrlAlt_6_Nod);
	Load_Radio_Command("CtrlAlt_7_GDI", CtrlAlt_7_GDI);
	Load_Radio_Command("CtrlAlt_7_Nod", CtrlAlt_7_Nod);
	Load_Radio_Command("CtrlAlt_8_GDI", CtrlAlt_8_GDI);
	Load_Radio_Command("CtrlAlt_8_Nod", CtrlAlt_8_Nod);
	Load_Radio_Command("CtrlAlt_9_GDI", CtrlAlt_9_GDI);
	Load_Radio_Command("CtrlAlt_9_Nod", CtrlAlt_9_Nod);
	Load_Radio_Command("CtrlAlt_0_GDI", CtrlAlt_0_GDI);
	Load_Radio_Command("CtrlAlt_0_Nod", CtrlAlt_0_Nod);

}

void Load_Taunt_Radio_Commands()
{
	Load_Radio_Command("Taunt1_GDI", Taunt1_GDI);
	Load_Radio_Command("Taunt2_GDI", Taunt2_GDI);
	Load_Radio_Command("Taunt3_GDI", Taunt3_GDI);
	Load_Radio_Command("Taunt4_GDI", Taunt4_GDI);
	Load_Radio_Command("Taunt5_GDI", Taunt5_GDI);
	Load_Radio_Command("Taunt6_GDI", Taunt6_GDI);
	Load_Radio_Command("Taunt7_GDI", Taunt7_GDI);
	Load_Radio_Command("Taunt8_GDI", Taunt8_GDI);
	Load_Radio_Command("Taunt9_GDI", Taunt9_GDI);

	Load_Radio_Command("Taunt1_Nod", Taunt1_Nod);
	Load_Radio_Command("Taunt2_Nod", Taunt2_Nod);
	Load_Radio_Command("Taunt3_Nod", Taunt3_Nod);
	Load_Radio_Command("Taunt4_Nod", Taunt4_Nod);
	Load_Radio_Command("Taunt5_Nod", Taunt5_Nod);
	Load_Radio_Command("Taunt6_Nod", Taunt6_Nod);
	Load_Radio_Command("Taunt7_Nod", Taunt7_Nod);
	Load_Radio_Command("Taunt8_Nod", Taunt8_Nod);
	Load_Radio_Command("Taunt9_Nod", Taunt9_Nod);
}

void CustomRadioCommands::OnLoadLevel()
{
	for (int i = 1; i < 127; i++)
	{
		LastPress[i] = 0;
	}

}

void CustomRadioCommands::OnObjectCreate(void *data,GameObject *obj)
{
	if (Commands->Is_A_Star)
	{
		Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt1,h_a_a0a0_l12");
		Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt2,H_A_a0a0_L22");
		Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt3,H_A_a0a0_L23");
		Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt4,H_A_a0a0_L24");
		Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt5,H_A_a0a0_L25");
		Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt6,H_A_a0a0_L58");
		Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt7,H_A_cresentkick");
		Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt8,H_A_sidekick");
		Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt9,H_A_punchcombo");
	}
}

CustomRadioCommands::CustomRadioCommands()
{
	RegisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
	RegisterEvent(EVENT_RADIO_HOOK, this);
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK, this);
	Plugin_Load();
}

CustomRadioCommands::~CustomRadioCommands()
{
	UnregisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
	UnregisterEvent(EVENT_RADIO_HOOK, this);
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK, this);
}


CustomRadioCommands customRadioCommands;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &customRadioCommands;
}
